//--------------------------------------------------------------
// Real Time Water -for darkbasic pro-
// by evolved
// un-tweaks ---------------------------------------------------
  matrix WorldViewProj:WorldViewProjection;
  float fTime;
// tweaks ------------------------------------------------------
  float u <> = 25.0f;
  float v <> = 25.0f;
// Textures ---------------------------------------------------- 
  texture water<string Name="";>;	
    sampler2D waterSampler=sampler_state
	{
	Texture = <water>;
   	ADDRESSU = CLAMP;
   	ADDRESSV = CLAMP;
   	ADDRESSW = CLAMP;
 	};
  texture bumpmap <string Name=""; >; 
     sampler2D bumpmapSampler=sampler_state 
	{
	Texture = <bumpmap>;
	};
// data structs  ----------------------------------------------
 struct input{
   float4 Position:POSITION;
   float2 UV:TEXCOORD;
  };
 struct output{
    float4 pos:POSITION;
    float2 uv:TEXCOORD0;
    float3 pos_view:TEXCOORD1; 
  };
// vertex shader -----------------------------------------------
 output VS(input IN)
  {
   output Out;
    Out.pos=mul(IN.Position,WorldViewProj);
    Out.uv=IN.UV*float2(u,v);
    Out.pos_view=Out.pos.xyz;
    return Out;
  }
// pixel shader  -----------------------------------------------
 float4 PS(output IN) : COLOR 
  {
   float2 wobble = float2(cos(fTime*2 + IN.uv.x*50)*0.013, sin(fTime*2 + IN.uv.y*50)*0.01);
   float4 bump=tex2D(bumpmapSampler,IN.uv+wobble)*2-1;
   float2 nuv=(0.5+(IN.pos_view.xy/IN.pos_view.z)*0.5)+((bump.xy*0.05)+0.005);
   float4 result=tex2D(waterSampler,nuv.xy);
   result.w=0.8;
   return result;
 }
// techniques    ------------------------------------------------
technique water
 {
  pass p1
   {		
    VertexShader = compile vs_2_0 VS(); 
    PixelShader = compile ps_2_0 PS(); 		
   }
  }
//--------------------------------------------------------------